<?php
require_once __DIR__.'/lomba/db.php';

function addColumnIfNotExists($mysqli, $table, $column, $definition) {
    $check = $mysqli->query("SHOW COLUMNS FROM $table LIKE '$column'");
    if ($check->num_rows == 0) {
        if ($mysqli->query("ALTER TABLE $table ADD COLUMN $column $definition")) {
            echo "Added column $column to $table.\n";
        } else {
            echo "Error adding column $column: " . $mysqli->error . "\n";
        }
    } else {
        echo "Column $column already exists in $table.\n";
    }
}

// Add columns to users table
addColumnIfNotExists($mysqli, 'users', 'streak_count', 'INT DEFAULT 0');
addColumnIfNotExists($mysqli, 'users', 'last_login_date', 'DATE');

// Create friends table
$createFriends = "CREATE TABLE IF NOT EXISTS friends (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT UNSIGNED NOT NULL,
    friend_id INT UNSIGNED NOT NULL,
    status ENUM('pending', 'accepted', 'blocked') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (friend_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_friendship (user_id, friend_id)
)";

if ($mysqli->query($createFriends)) {
    echo "Created/Checked friends table successfully.\n";
} else {
    echo "Error creating friends table: " . $mysqli->error . "\n";
}
?>
