<?php
require_once 'db.php';

header('Content-Type: application/json');

// Validated Ishihara Plates Data
// Source images from a reliable public repo (using raw.githubusercontent.com)
// These are standard Ishihara plates.
$plates = [
    // TYPE 1: Protan (Red-Blind) Focus
    [ 'id' => 1, 'url' => '/ishihara/data/1_Asap-MediumItalictheme_1 type_1.png', 'expected' => '1', 'cat' => 'protan', 'desc' => 'Protan Test 1' ],
    [ 'id' => 2, 'url' => '/ishihara/data/4_Changa-Boldtheme_1 type_1.png', 'expected' => '4', 'cat' => 'protan', 'desc' => 'Protan Test 2' ],
    [ 'id' => 3, 'url' => '/ishihara/data/7_Ramaraja-Regulartheme_1 type_1.png', 'expected' => '7', 'cat' => 'protan', 'desc' => 'Protan Test 3' ],
    [ 'id' => 4, 'url' => '/ishihara/data/2_Varela-Regulartheme_1 type_1.png', 'expected' => '2', 'cat' => 'protan', 'desc' => 'Protan Test 4' ],
    [ 'id' => 5, 'url' => '/ishihara/data/5_Tillana-Boldtheme_1 type_1.png', 'expected' => '5', 'cat' => 'protan', 'desc' => 'Protan Test 5' ],

    // TYPE 2: Deutan (Green-Blind) Focus
    [ 'id' => 6, 'url' => '/ishihara/data/2_Asap-MediumItalictheme_2 type_2.png', 'expected' => '2', 'cat' => 'deutan', 'desc' => 'Deutan Test 1' ],
    [ 'id' => 7, 'url' => '/ishihara/data/5_Changa-Boldtheme_2 type_2.png', 'expected' => '5', 'cat' => 'deutan', 'desc' => 'Deutan Test 2' ],
    [ 'id' => 8, 'url' => '/ishihara/data/8_Ramaraja-Regulartheme_2 type_2.png', 'expected' => '8', 'cat' => 'deutan', 'desc' => 'Deutan Test 3' ],
    [ 'id' => 9, 'url' => '/ishihara/data/3_Varela-Regulartheme_2 type_2.png', 'expected' => '3', 'cat' => 'deutan', 'desc' => 'Deutan Test 4' ],
    [ 'id' => 10, 'url' => '/ishihara/data/6_Tillana-Boldtheme_2 type_2.png', 'expected' => '6', 'cat' => 'deutan', 'desc' => 'Deutan Test 5' ],

    // TYPE 3: Tritan (Blue-Blind) Focus
    [ 'id' => 11, 'url' => '/ishihara/data/3_Asap-MediumItalictheme_3 type_3.png', 'expected' => '3', 'cat' => 'tritan', 'desc' => 'Tritan Test 1' ],
    [ 'id' => 12, 'url' => '/ishihara/data/6_Changa-Boldtheme_3 type_3.png', 'expected' => '6', 'cat' => 'tritan', 'desc' => 'Tritan Test 2' ],
    [ 'id' => 13, 'url' => '/ishihara/data/9_Ramaraja-Regulartheme_3 type_3.png', 'expected' => '9', 'cat' => 'tritan', 'desc' => 'Tritan Test 3' ],
    [ 'id' => 14, 'url' => '/ishihara/data/1_Varela-Regulartheme_3 type_3.png', 'expected' => '1', 'cat' => 'tritan', 'desc' => 'Tritan Test 4' ],
    [ 'id' => 15, 'url' => '/ishihara/data/4_Tillana-Boldtheme_3 type_3.png', 'expected' => '4', 'cat' => 'tritan', 'desc' => 'Tritan Test 5' ]
];

echo json_encode(['data' => $plates]);
?>
