<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Geng Kucing: Solo Park Adventure</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=VT323&display=swap');

        body {
            background-color: #2c3e50;
            color: white;
            font-family: 'VT323', monospace;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            overflow: hidden;
            touch-action: none;
            /* Prevent browser zooming/scrolling on mobile */
        }

        #game-container {
            position: fixed !important;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
            border: 4px solid #ecf0f1;
            max-width: 100%;
            max-height: 100%;
        }

        canvas {
            display: block;
            background-color: #87CEEB;
        }

        #ui-layer {
            position: absolute;
            top: 10px;
            left: 10px;
            font-size: 24px;
            text-shadow: 2px 2px 0 #000;
            pointer-events: none;
            z-index: 10;
        }

        /* PC Controls Instructions */
        .controls {
            margin-top: 15px;
            text-align: center;
            font-size: 20px;
            background: rgba(0, 0, 0, 0.3);
            padding: 10px 20px;
            border-radius: 8px;
        }

        .key-badge {
            display: inline-block;
            background: #fff;
            color: #333;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: bold;
            margin: 0 2px;
        }

        #back-btn {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #e74c3c;
            color: white;
            text-decoration: none;
            padding: 5px 10px;
            border-radius: 5px;
            font-family: 'VT323', monospace;
            font-size: 20px;
            border: 2px solid #c0392b;
            z-index: 100;
        }

        #back-btn:hover {
            background: #c0392b;
        }

        /* Mobile Controls */
        #mobile-controls {
            display: none;
            /* Hidden by default on PC */
            position: absolute;
            bottom: 10px;
            left: 0;
            width: 100%;
            height: 160px;
            pointer-events: none;
            z-index: 20;
        }

        .control-btn {
            position: absolute;
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid rgba(255, 255, 255, 0.5);
            border-radius: 50%;
            pointer-events: auto;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 24px;
            user-select: none;
            touch-action: manipulation;
            color: white;
            font-weight: bold;
        }

        .control-btn:active {
            background: rgba(255, 255, 255, 0.5);
        }

        #btn-left {
            bottom: 20px;
            left: 20px;
        }

        #btn-right {
            bottom: 20px;
            left: 100px;
        }

        #btn-up {
            bottom: 90px;
            left: 60px;
        }

        /* Jump button placed above/between left-right */

        #btn-stack {
            bottom: 30px;
            right: 30px;
            width: 80px;
            height: 80px;
            border-radius: 15px;
            font-size: 20px;
            background: rgba(241, 196, 15, 0.3);
            border-color: rgba(241, 196, 15, 0.6);
        }

        /* Pop-up Quiz Styles */
        #quiz-overlay {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 100;
            justify-content: center;
            align-items: center;
        }

        #quiz-box {
            background: #fff;
            color: #2c3e50;
            padding: 20px;
            border: 4px solid #f1c40f;
            border-radius: 10px;
            width: 80%;
            max-width: 400px;
            text-align: center;
            font-family: 'VT323', monospace;
        }

        #quiz-question {
            font-size: 24px;
            margin-bottom: 20px;
        }

        .quiz-btn {
            display: block;
            width: 100%;
            margin: 10px 0;
            padding: 10px;
            background: #3498db;
            color: white;
            border: none;
            font-size: 20px;
            cursor: pointer;
            font-family: 'VT323', monospace;
        }

        .quiz-btn:hover {
            background: #2980b9;
        }

        .wrong-anim {
            animation: shake 0.5s;
        }

        @keyframes shake {
            0% {
                transform: translateX(0);
            }

            25% {
                transform: translateX(-5px);
            }

            50% {
                transform: translateX(5px);
            }

            75% {
                transform: translateX(-5px);
            }

            100% {
                transform: translateX(0);
            }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            #mobile-controls {
                display: block;
            }

            /* Show mobile controls */
            .controls {
                display: none;
            }

            /* Hide PC instructions */

            #game-container {
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100vw !important;
                height: 100vh !important;
                max-width: 100vw !important;
                max-height: 100vh !important;
                border: none !important;
                box-shadow: none !important;
            }

            canvas {
                width: 100% !important;
                height: 100% !important;
                object-fit: contain !important;
            }
        }
    </style>
</head>

<body>
<div id="game-container">
        <canvas id="gameCanvas" width="800" height="450"></canvas>
        <div id="ui-layer">Level: <span id="level-display">1</span> | Kunci: <span id="key-display">0/1</span></div>
        <a id="back-btn" href="index.php?spawn=gaming_room">KEMBALI</a>

        <!-- Mobile Controls Overlay -->
        <div id="mobile-controls">
            <div id="btn-left" class="control-btn">←</div>
            <div id="btn-right" class="control-btn">→</div>
            <div id="btn-up" class="control-btn">↑</div>
            <div id="btn-stack" class="control-btn">STACK</div>
        </div>

        <!-- Pop-up Quiz HTML -->
        <div id="quiz-overlay">
            <div id="quiz-box">
                <h2 style="margin-top:0;">PERTANYAAN PENJAGA KUNCI</h2>
                <p id="quiz-question">Loading...</p>
                <div id="quiz-options"></div>
            </div>
        </div>

        <!-- Tutorial Overlay (How to Play) -->
        <div id="tutorial-overlay" style="
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(8px);
            z-index: 200;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            padding: 20px;
            box-sizing: border-box;
        ">
            <div style="
                background: rgba(30, 41, 59, 0.9);
                border: 2px solid #22d3ee;
                border-radius: 16px;
                padding: 30px;
                max-width: 450px;
                box-shadow: 0 0 30px rgba(34, 211, 238, 0.3);
            ">
                <h1 style="color: #22d3ee; font-size: 28px; margin-bottom: 15px;">🐱 Geng Kucing: Solo Park</h1>
                <p style="color: #94a3b8; font-size: 18px; margin-bottom: 20px;">Kendalikan 3 kucing sekaligus untuk menyelesaikan puzzle!</p>
                
                <div style="text-align: left; color: #e2e8f0; font-size: 16px; line-height: 1.8; margin-bottom: 25px;">
                    <p>⬅️ ➡️ <strong>Panah / A D</strong> - Gerak kiri/kanan</p>
                    <p>⬆️ <strong>Panah Atas / W</strong> - Lompat</p>
                    <p>🔲 <strong>SPASI</strong> - Formasi Menara</p>
                    <p>🔄 <strong>R</strong> - Restart Level</p>
                </div>
                
                <button id="start-game-btn" style="
                    background: linear-gradient(135deg, #22d3ee, #06b6d4);
                    color: #0f172a;
                    font-family: 'VT323', monospace;
                    font-size: 24px;
                    font-weight: bold;
                    padding: 15px 40px;
                    border: none;
                    border-radius: 10px;
                    cursor: pointer;
                    transition: all 0.2s ease;
                    box-shadow: 0 4px 15px rgba(34, 211, 238, 0.4);
                ">
                    🎮 MULAI MAIN
                </button>
            </div>
        </div>
    </div>

    <div class="controls">
        Gerak: <span class="key-badge">←</span> <span class="key-badge">→</span> / <span class="key-badge">A</span>
        <span class="key-badge">D</span> &nbsp;|&nbsp;
        Lompat: <span class="key-badge">↑</span> / <span class="key-badge">W</span> &nbsp;|&nbsp;
        Formasi: <span class="key-badge">SPASI</span> &nbsp;|&nbsp;
        Restart: <span class="key-badge">R</span>
    </div>

    <script>
        // Aspect Ratio Fitting Logic
        function resizeGame() {
            const container = document.getElementById('game-container');
            const canvas = document.getElementById('gameCanvas');
            const windowWidth = window.innerWidth;
            const windowHeight = window.innerHeight;

            const targetRatio = 16 / 9;
            const windowRatio = windowWidth / windowHeight;

            let newWidth, newHeight;

            if (windowRatio > targetRatio) {
                // Window is wider than game (fit to height)
                newHeight = windowHeight;
                newWidth = newHeight * targetRatio;
            } else {
                // Window is narrower than game (fit to width)
                newWidth = windowWidth;
                newHeight = newWidth / targetRatio;
            }

            // Apply size to container
            container.style.width = newWidth + 'px';
            container.style.height = newHeight + 'px';

            // Center the container
            container.style.position = 'absolute';
            container.style.left = (windowWidth - newWidth) / 2 + 'px';
            container.style.top = (windowHeight - newHeight) / 2 + 'px';

            // Ensure canvas fills container
            canvas.style.width = '100%';
            canvas.style.height = '100%';
        }

        window.addEventListener('resize', resizeGame);
        window.addEventListener('orientationchange', resizeGame);
        // Call initially
        window.addEventListener('DOMContentLoaded', resizeGame);
    </script>
    <script>
        /**
         * Geng Kucing: Solo Park Adventure
         * A single-player adaptation of Pico Park style mechanics.
         * Control 3 cats simultaneously to solve physics puzzles.
         */

        const canvas = document.getElementById('gameCanvas');
        const ctx = canvas.getContext('2d');

        // --- Game Constants ---
        const TILE_SIZE = 40;
        const GRAVITY = 0.5;
        const JUMP_FORCE = -11;
        const SPEED = 5;
        const FRICTION = 0.8;

        // --- Colors ---
        const COLORS = {
            sky: '#87CEEB',
            ground: '#5D4037',
            groundTop: '#8D6E63',
            cats: ['#FF6B6B', '#4ECDC4', '#FFE66D'], // Red, Teal, Yellow
            door: '#2C3E50',
            doorOpen: '#34495E',
            key: '#FFD700',
            heavyBlock: '#555555'
        };

        // --- Input Handling ---
        const keys = {
            ArrowUp: false,
            ArrowLeft: false,
            ArrowRight: false,
            KeyW: false,
            KeyA: false,
            KeyD: false,
            Space: false,
            KeyR: false
        };

        // Data Pertanyaan untuk setiap Level
        const QUESTIONS = {
            1: {
                q: "Berapa jumlah kucing yang kamu kendalikan?",
                options: ["1 Kucing", "3 Kucing", "5 Kucing"],
                correct: 1 // Index jawaban benar (3 Kucing)
            },
            2: {
                q: "Tombol apa untuk mengubah formasi jadi Menara?",
                options: ["Enter", "Shift", "Spasi"],
                correct: 2 // Index jawaban benar (Spasi)
            },
            3: {
                q: "Apa warna kucing pertama (paling bawah)?",
                options: ["Merah", "Kuning", "Hijau"],
                correct: 0 // Index jawaban benar (Merah)
            }
        };

        // Load soal dari Database berdasarkan game_id (jika tersedia) lalu override dengan localStorage bila ada
        (async ()=>{
            try{
                const params = new URLSearchParams(location.search)
                const gid = Number(params.get('game_id')||'0')
                if(gid>0){
                    const res = await fetch('questions.php?game_id='+gid)
                    if(res.ok){
                        const data = await res.json()
                        if(data && typeof data === 'object'){
                            Object.keys(data).forEach(lvl=>{ if(QUESTIONS[lvl]) QUESTIONS[lvl] = data[lvl] })
                            console.log('Menggunakan Soal dari Database untuk game', gid)
                        }
                    }
                }
            }catch(e){ console.warn('Gagal load soal DB', e) }
            // Fallback/override: cek localStorage customQuestions
            try{
                const customData = localStorage.getItem('customQuestions');
                if (customData) {
                    const parsedData = JSON.parse(customData);
                    Object.keys(parsedData).forEach(lvl => { if (QUESTIONS[lvl]) { QUESTIONS[lvl] = parsedData[lvl]; } });
                    console.log('Override soal dari Guru (localStorage)');
                }
            }catch(e){ console.error('Gagal memuat soal guru', e) }
        })()

        window.addEventListener('keydown', (e) => {
            if (game && game.isQuizActive) return;
            if (e.code === 'Space') e.preventDefault();
            if (keys[e.code] !== undefined) keys[e.code] = true;

            if (e.code === 'Space' && !game.spaceLocked) {
                game.toggleStack();
                game.spaceLocked = true;
            }
            if (e.code === 'KeyR') {
                game.restartLevel();
            }
        });

        window.addEventListener('keyup', (e) => {
            if (game && game.isQuizActive) return;
            if (keys[e.code] !== undefined) keys[e.code] = false;
            if (e.code === 'Space') {
                game.spaceLocked = false;
            }
        });

        // --- Mobile Touch Controls ---
        function setupMobileControls() {
            const btnLeft = document.getElementById('btn-left');
            const btnRight = document.getElementById('btn-right');
            const btnUp = document.getElementById('btn-up');
            const btnStack = document.getElementById('btn-stack');

            const handleTouch = (code, isDown) => {
                if (isDown) {
                    if (code === 'Space' && !game.spaceLocked) {
                        game.toggleStack();
                        game.spaceLocked = true;
                    }
                    if (keys[code] !== undefined) keys[code] = true;
                } else {
                    if (keys[code] !== undefined) keys[code] = false;
                    if (code === 'Space') game.spaceLocked = false;
                }
            };

            const addTouchListener = (elem, code) => {
                if (!elem) return;
                elem.addEventListener('touchstart', (e) => { e.preventDefault(); handleTouch(code, true); });
                elem.addEventListener('touchend', (e) => { e.preventDefault(); handleTouch(code, false); });
                // Mouse events for testing on PC with mouse
                elem.addEventListener('mousedown', (e) => { e.preventDefault(); handleTouch(code, true); });
                elem.addEventListener('mouseup', (e) => { e.preventDefault(); handleTouch(code, false); });
            };

            addTouchListener(btnLeft, 'ArrowLeft');
            addTouchListener(btnRight, 'ArrowRight');
            addTouchListener(btnUp, 'ArrowUp');
            addTouchListener(btnStack, 'Space');
        }

        setTimeout(setupMobileControls, 100);

        // --- Classes ---

        class Cat {
            constructor(id, color) {
                this.id = id;
                this.width = 30;
                this.height = 30;
                this.color = color;
                this.x = 0;
                this.y = 0;
                this.vx = 0;
                this.vy = 0;
                this.grounded = false;
                this.facingRight = true;
            }

            update(obstacles, pushables, isStacked, leader) {
                this.vy += GRAVITY;
                this.x += this.vx;
                this.y += this.vy;
                this.vx *= FRICTION;

                if (isStacked && this.id !== 0) {
                    const stackOffset = this.id * 30;
                    const desiredX = leader.x;
                    const desiredY = leader.y - stackOffset;
                    this.x = this.x + (desiredX - this.x) * 0.5;
                    this.vx = leader.vx;
                    this.y = desiredY;
                    this.vy = leader.vy;
                    this.grounded = leader.grounded;
                    return;
                }

                this.grounded = false;

                for (let obs of obstacles) {
                    const dir = this.colCheck(obs);
                    if (dir === "b") this.grounded = true;
                }

                for (let block of pushables) {
                    const dir = this.colCheck(block);
                    if (dir === "l" || dir === "r") {
                        block.isBeingPushed = true;
                        block.pushDirection = (dir === "l") ? 1 : -1;
                    }
                    if (dir === "b") this.grounded = true;
                }

                if (this.x < 0) { this.x = 0; this.vx = 0; }
                if (this.x > canvas.width - this.width) { this.x = canvas.width - this.width; this.vx = 0; }
                if (this.y > canvas.height) { game.restartLevel(); }
            }

            draw() {
                ctx.fillStyle = this.color;
                ctx.fillRect(this.x, this.y, this.width, this.height);
                ctx.fillStyle = "black";
                if (this.facingRight) {
                    ctx.fillRect(this.x + 20, this.y + 8, 4, 4);
                    ctx.fillRect(this.x + 8, this.y + 8, 4, 4);
                } else {
                    ctx.fillRect(this.x + 2, this.y + 8, 4, 4);
                    ctx.fillRect(this.x + 14, this.y + 8, 4, 4);
                }
                ctx.fillStyle = this.color;
                ctx.beginPath();
                ctx.moveTo(this.x, this.y);
                ctx.lineTo(this.x + 8, this.y - 8);
                ctx.lineTo(this.x + 12, this.y);
                ctx.fill();
                ctx.beginPath();
                ctx.moveTo(this.x + this.width, this.y);
                ctx.lineTo(this.x + this.width - 8, this.y - 8);
                ctx.lineTo(this.x + this.width - 12, this.y);
                ctx.fill();
                ctx.strokeStyle = "rgba(0,0,0,0.2)";
                ctx.strokeRect(this.x, this.y, this.width, this.height);
            }

            colCheck(shape) {
                const vX = (this.x + (this.width / 2)) - (shape.x + (shape.width / 2));
                const vY = (this.y + (this.height / 2)) - (shape.y + (shape.height / 2));
                const hWidths = (this.width / 2) + (shape.width / 2);
                const hHeights = (this.height / 2) + (shape.height / 2);
                let colDir = null;

                if (Math.abs(vX) < hWidths && Math.abs(vY) < hHeights) {
                    const oX = hWidths - Math.abs(vX);
                    const oY = hHeights - Math.abs(vY);
                    if (oX >= oY) {
                        if (vY > 0) { colDir = "t"; this.y += oY; this.vy = 0; }
                        else { colDir = "b"; this.y -= oY; this.vy = 0; }
                    } else {
                        if (vX > 0) { colDir = "l"; this.x += oX; this.vx = 0; }
                        else { colDir = "r"; this.x -= oX; this.vx = 0; }
                    }
                }
                return colDir;
            }
        }

        class PushBlock {
            constructor(x, y, w, h, weight) {
                this.x = x; this.y = y; this.width = w; this.height = h;
                this.weight = weight; this.vx = 0; this.vy = 0;
                this.isBeingPushed = false; this.pushDirection = 0;
            }

            update(obstacles) {
                this.vy += GRAVITY;
                this.y += this.vy;
                this.isBeingPushed = false;
                this.pushDirection = 0;
                this.vx *= 0.5;
                this.x += this.vx;
                for (let obs of obstacles) { this.colCheck(obs); }
            }

            draw() {
                ctx.fillStyle = COLORS.heavyBlock;
                ctx.fillRect(this.x, this.y, this.width, this.height);
                ctx.fillStyle = "white";
                ctx.font = "20px VT323";
                ctx.textAlign = "center";
                ctx.fillText(this.weight + "X", this.x + this.width / 2, this.y + this.height / 2 + 5);
                ctx.strokeStyle = "#333";
                ctx.lineWidth = 2;
                ctx.strokeRect(this.x, this.y, this.width, this.height);
                ctx.beginPath();
                ctx.moveTo(this.x, this.y);
                ctx.lineTo(this.x + this.width, this.y + this.height);
                ctx.moveTo(this.x + this.width, this.y);
                ctx.lineTo(this.x, this.y + this.height);
                ctx.stroke();
            }

            colCheck(shape) {
                const vX = (this.x + (this.width / 2)) - (shape.x + (shape.width / 2));
                const vY = (this.y + (this.height / 2)) - (shape.y + (shape.height / 2));
                const hWidths = (this.width / 2) + (shape.width / 2);
                const hHeights = (this.height / 2) + (shape.height / 2);

                if (Math.abs(vX) < hWidths && Math.abs(vY) < hHeights) {
                    const oX = hWidths - Math.abs(vX);
                    const oY = hHeights - Math.abs(vY);
                    if (oX >= oY) {
                        if (vY > 0) { this.y += oY; this.vy = 0; }
                        else { this.y -= oY; this.vy = 0; }
                    } else {
                        if (vX > 0) { this.x += oX; this.vx = 0; }
                        else { this.x -= oX; this.vx = 0; }
                    }
                }
            }
        }

        class Game {
            constructor() {
                this.level = 1;
                this.cats = [];
                this.obstacles = [];
                this.pushables = [];
                this.key = null;
                this.door = null;
                this.hasKey = false;
                this.isStacked = false;
                this.spaceLocked = false;
                this.completed = false;
                this.isQuizActive = false;
                this.isPaused = true; // Start paused for tutorial
                this.initLevel(this.level);
            }

            initLevel(lvl) {
                this.cats = [];
                this.obstacles = [];
                this.pushables = [];
                this.hasKey = false;
                this.completed = false;
                this.isStacked = false;
                this.isQuizActive = false;
                document.getElementById('quiz-overlay').style.display = 'none';

                for (let i = 0; i < 3; i++) {
                    let c = new Cat(i, COLORS.cats[i]);
                    c.x = 50 + (i * 40);
                    c.y = 300;
                    this.cats.push(c);
                }

                if (lvl === 1) {
                    this.obstacles.push({ x: 0, y: 400, width: 800, height: 50 });
                    this.obstacles.push({ x: 0, y: 0, width: 20, height: 450 });
                    this.obstacles.push({ x: 780, y: 0, width: 20, height: 450 });
                    this.obstacles.push({ x: 250, y: 300, width: 150, height: 20 });
                    this.obstacles.push({ x: 480, y: 220, width: 150, height: 20 });
                    this.key = { x: 530, y: 180, width: 20, height: 20, active: true };
                    this.door = { x: 700, y: 320, width: 50, height: 80 };
                } else if (lvl === 2) {
                    this.cats.forEach((c, i) => c.x = 50 + i * 10);
                    this.obstacles.push({ x: 0, y: 400, width: 800, height: 50 });
                    this.obstacles.push({ x: 0, y: 0, width: 20, height: 450 });
                    this.obstacles.push({ x: 780, y: 0, width: 20, height: 450 });
                    this.obstacles.push({ x: 400, y: 250, width: 20, height: 150 });
                    this.pushables.push(new PushBlock(200, 300, 60, 60, 3));
                    this.obstacles.push({ x: 100, y: 200, width: 100, height: 20 });
                    this.key = { x: 130, y: 160, width: 20, height: 20, active: true };
                    this.door = { x: 700, y: 320, width: 50, height: 80 };
                } else if (lvl === 3) {
                    this.obstacles.push({ x: 0, y: 400, width: 280, height: 50 });
                    this.obstacles.push({ x: 450, y: 400, width: 350, height: 50 });
                    this.obstacles.push({ x: 0, y: 0, width: 20, height: 450 });
                    this.obstacles.push({ x: 780, y: 0, width: 20, height: 450 });
                    this.obstacles.push({ x: 320, y: 320, width: 80, height: 20 });
                    this.pushables.push(new PushBlock(500, 300, 60, 60, 3));
                    this.key = { x: 350, y: 280, width: 20, height: 20, active: true };
                    this.door = { x: 700, y: 320, width: 50, height: 80 };
                } else {
                    this.completed = true;
                }
                this.updateUI();
            }

            toggleStack() {
                this.isStacked = !this.isStacked;
            }

            triggerQuiz() {
                this.isQuizActive = true;
                Object.keys(keys).forEach(k => keys[k] = false);
                const qData = QUESTIONS[this.level];
                const overlay = document.getElementById('quiz-overlay');
                const qText = document.getElementById('quiz-question');
                const qOptions = document.getElementById('quiz-options');
                qText.innerText = qData.q;
                qOptions.innerHTML = '';
                qData.options.forEach((opt, index) => {
                    const btn = document.createElement('button');
                    btn.className = 'quiz-btn';
                    btn.innerText = opt;
                    btn.onclick = () => this.handleAnswer(index, qData.correct);
                    qOptions.appendChild(btn);
                });
                overlay.style.display = 'flex';
            }

            handleAnswer(selectedIndex, correctIndex) {
                if (selectedIndex === correctIndex) {
                    document.getElementById('quiz-overlay').style.display = 'none';
                    this.isQuizActive = false;
                    this.hasKey = true;
                    this.key.active = false;
                    this.updateUI();
                } else {
                    const box = document.getElementById('quiz-box');
                    box.classList.add('wrong-anim');
                    setTimeout(() => box.classList.remove('wrong-anim'), 500);
                }
            }

            restartLevel() {
                this.initLevel(this.level);
            }

            update() {
                if (this.completed || this.isQuizActive || this.isPaused) return;

                let moveForce = 0;
                if (keys.ArrowLeft || keys.KeyA) moveForce = -1;
                if (keys.ArrowRight || keys.KeyD) moveForce = 1;
                let jump = keys.ArrowUp || keys.KeyW;

                this.pushables.forEach(block => {
                    let pushers = 0;
                    this.cats.forEach(cat => {
                        if (cat.y + cat.height > block.y && cat.y < block.y + block.height) {
                            if (Math.abs((cat.x + cat.width / 2) - (block.x + block.width / 2)) < (cat.width / 2 + block.width / 2 + 2)) {
                                pushers++;
                            }
                        }
                    });
                    if (pushers >= block.weight && moveForce !== 0) {
                        block.vx = moveForce * 2;
                    }
                    block.update(this.obstacles);
                });

                if (this.isStacked) {
                    let leader = this.cats[0];
                    if (moveForce !== 0) {
                        leader.vx += moveForce * 0.5;
                        if (leader.vx > SPEED) leader.vx = SPEED;
                        if (leader.vx < -SPEED) leader.vx = -SPEED;
                        leader.facingRight = moveForce > 0;
                    }
                    if (jump && leader.grounded) {
                        leader.vy = JUMP_FORCE;
                    }
                    this.cats.forEach(c => c.facingRight = leader.facingRight);
                    leader.update(this.obstacles, this.pushables, false, null);
                    for (let i = 1; i < this.cats.length; i++) {
                        this.cats[i].update(this.obstacles, this.pushables, true, leader);
                    }
                } else {
                    this.cats.forEach(cat => {
                        if (moveForce !== 0) {
                            cat.vx += moveForce * 0.5;
                            if (cat.vx > SPEED) cat.vx = SPEED;
                            if (cat.vx < -SPEED) cat.vx = -SPEED;
                            cat.facingRight = moveForce > 0;
                        }
                        if (jump && cat.grounded) {
                            cat.vy = JUMP_FORCE;
                        }
                        cat.update(this.obstacles, this.pushables, false, null);
                    });
                }

                if (this.key && this.key.active) {
                    for (let cat of this.cats) {
                        if (this.checkOverlap(cat, this.key)) {
                            this.triggerQuiz();
                            break;
                        }
                    }
                }

                if (this.hasKey) {
                    let allIn = true;
                    for (let cat of this.cats) {
                        if (!this.checkOverlap(cat, this.door)) {
                            allIn = false;
                        }
                    }
                    if (allIn) {
                        this.level++;
                        this.initLevel(this.level);
                    }
                }
            }

            checkOverlap(rect1, rect2) {
                return (rect1.x < rect2.x + rect2.width && rect1.x + rect1.width > rect2.x && rect1.y < rect2.y + rect2.height && rect1.y + rect1.height > rect2.y);
            }

            draw() {
                ctx.clearRect(0, 0, canvas.width, canvas.height);
                if (this.completed) {
                    ctx.fillStyle = "#2c3e50";
                    ctx.fillRect(0, 0, canvas.width, canvas.height);
                    ctx.fillStyle = "#f1c40f";
                    ctx.font = "60px VT323";
                    ctx.textAlign = "center";
                    ctx.fillText("SELAMAT! KAMU MENANG!", canvas.width / 2, canvas.height / 2);
                    ctx.font = "30px VT323";
                    ctx.fillStyle = "white";
                    ctx.fillText("Geng Kucing berhasil lolos.", canvas.width / 2, canvas.height / 2 + 50);
                    return;
                }

                ctx.fillStyle = COLORS.ground;
                for (let obs of this.obstacles) {
                    ctx.fillRect(obs.x, obs.y, obs.width, obs.height);
                    ctx.fillStyle = COLORS.groundTop;
                    ctx.fillRect(obs.x, obs.y, obs.width, 5);
                    ctx.fillStyle = COLORS.ground;
                }

                ctx.fillStyle = this.hasKey ? COLORS.doorOpen : COLORS.door;
                ctx.fillRect(this.door.x, this.door.y, this.door.width, this.door.height);
                ctx.strokeStyle = "#95a5a6";
                ctx.lineWidth = 4;
                ctx.strokeRect(this.door.x, this.door.y, this.door.width, this.door.height);

                if (this.key && this.key.active) {
                    ctx.fillStyle = COLORS.key;
                    const kx = this.key.x;
                    const ky = this.key.y + Math.sin(Date.now() / 200) * 5;
                    ctx.beginPath();
                    ctx.arc(kx + 10, ky + 10, 8, 0, Math.PI * 2);
                    ctx.fill();
                    ctx.fillRect(kx + 10, ky + 6, 12, 8);
                }

                for (let block of this.pushables) {
                    block.draw();
                }

                for (let cat of this.cats) {
                    cat.draw();
                }

                if (this.isStacked) {
                    ctx.strokeStyle = "rgba(255,255,255,0.3)";
                    ctx.setLineDash([5, 5]);
                    ctx.beginPath();
                    ctx.moveTo(this.cats[0].x + 15, this.cats[0].y);
                    ctx.lineTo(this.cats[0].x + 15, this.cats[2].y);
                    ctx.stroke();
                    ctx.setLineDash([]);
                }
            }

            updateUI() {
                document.getElementById('level-display').innerText = this.level;
                const keyText = this.hasKey ? "1/1 (Buka Pintu!)" : "0/1";
                document.getElementById('key-display').innerText = keyText;
                document.getElementById('key-display').style.color = this.hasKey ? "#2ecc71" : "#e74c3c";
            }
        }

        const game = new Game();

        // Tutorial Start Button Handler
        const startBtn = document.getElementById('start-game-btn');
        const tutorialOverlay = document.getElementById('tutorial-overlay');
        if (startBtn && tutorialOverlay) {
            startBtn.addEventListener('click', () => {
                tutorialOverlay.style.display = 'none';
                game.isPaused = false;
            });
        }

        function loop() {
            game.update();
            game.draw();
            requestAnimationFrame(loop);
        }
        loop();
    </script>
</body>

</html>


