<?php
/**
 * API Proxy untuk Groq
 * Menerima request dari JavaScript dan forward ke Groq API
 * API Key aman di server, tidak terekspos ke browser
 */

// Load konfigurasi
require_once 'config.php';

// Set headers untuk CORS dan JSON
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Hanya terima POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed. Use POST.']);
    exit();
}

// Ambil data dari request
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validasi input
if (!$data || !isset($data['message'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing message parameter']);
    exit();
}

// Siapkan request ke Groq
// LIMITASI: Hanya untuk materi SD Kelas 1-6
$sdSystemPrompt = "Kamu adalah Pak Guru AI, guru virtual untuk siswa SD kelas 1 sampai 6.

ATURAN KETAT:
1. Kamu HANYA boleh menjawab pertanyaan tentang materi pelajaran SD kelas 1-6, termasuk:
   - Matematika (penjumlahan, pengurangan, perkalian, pembagian, pecahan, geometri dasar)
   - Bahasa Indonesia (membaca, menulis, tata bahasa, cerita anak)
   - IPA (tumbuhan, hewan, tubuh manusia, alam sekitar, cuaca)
   - IPS (keluarga, lingkungan, sejarah Indonesia dasar, peta)
   - PKn/Pancasila (nilai-nilai moral, gotong royong, kebhinekaan)
   - Seni Budaya (menggambar, musik, tarian tradisional)
   - PJOK (olahraga dasar, kesehatan)
   - Bahasa Inggris dasar (vocabulary, simple sentences)
   - Agama (nilai-nilai kebaikan umum)

2. Jika ada pertanyaan di LUAR materi SD kelas 1-6, jawab dengan sopan:
   \"Maaf, Pak Guru hanya bisa membantu materi pelajaran SD kelas 1 sampai 6. Silakan tanyakan tentang Matematika, Bahasa Indonesia, IPA, IPS, atau pelajaran SD lainnya ya! 📚\"

3. Gunakan bahasa yang SEDERHANA dan mudah dipahami anak SD.
4. Berikan contoh yang menarik dan relevan untuk anak-anak.
5. Jangan membahas topik dewasa, politik kontroversial, kekerasan, atau hal-hal tidak pantas untuk anak SD.

Jawab dengan ramah dan menyemangati seperti guru yang baik! 🎓";

$userMessage = $data['message'];
$maxTokens = isset($data['max_tokens']) ? intval($data['max_tokens']) : 1024;
$temperature = isset($data['temperature']) ? floatval($data['temperature']) : 0.7;

// Gunakan system prompt dari request jika ada, jika tidak gunakan default SD
$systemPrompt = isset($data['system_prompt']) ? $data['system_prompt'] : $sdSystemPrompt;

$payload = [
    'model' => GROQ_MODEL,
    'messages' => [
        ['role' => 'system', 'content' => $systemPrompt],
        ['role' => 'user', 'content' => $userMessage]
    ],
    'temperature' => $temperature,
    'max_tokens' => $maxTokens
];

// Kirim request ke Groq API
$ch = curl_init(GROQ_API_URL);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . GROQ_API_KEY
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

// Handle curl error
if ($curlError) {
    http_response_code(500);
    echo json_encode(['error' => 'Connection error: ' . $curlError]);
    exit();
}

// Return response dari Groq
http_response_code($httpCode);
echo $response;
?>
