import React from 'react'
import CourseGrid from '../components/CourseGrid'
import FriendsBar from '../components/FriendsBar'
import { Link, useLocation } from 'react-router-dom'
import { sfx } from '../utils/audio'
import { getUser } from '../utils/storage'

export default function Home() {
  const location = useLocation()
  const user = getUser()
  const streak = user?.streak_count || 0

  return (
    <div className="space-y-8">
      <FriendsBar />
      {/* Hero Section */}
      <section className="relative overflow-hidden rounded-3xl bg-gradient-to-br from-indigo-500 via-purple-500 to-pink-500 text-white shadow-xl p-8 md:p-12">
        <div className="relative z-10 max-w-2xl">
          <div className="inline-block px-3 py-1 mb-4 text-xs font-bold tracking-wider uppercase bg-white/20 rounded-full backdrop-blur-sm border border-white/30">
            👋 Selamat Datang, {user?.name || 'Teman'}!
          </div>
          <h1 className="heading text-4xl md:text-5xl lg:text-6xl mb-4 leading-tight">
            Belajar Jadi Lebih <br />
            <span className="text-yellow-300 drop-shadow-md">Seru & Ajaib! ✨</span>
          </h1>
          <p className="ui text-lg md:text-xl text-white/90 mb-8 max-w-lg leading-relaxed">
            Jelajahi dunia pengetahuan dengan cara yang menyenangkan. Mainkan game, kerjakan kuis, dan raih prestasimu!
          </p>
          <div className="flex flex-wrap gap-4">
            <button onClick={() => document.getElementById('courses').scrollIntoView({ behavior: 'smooth' })} className="ui bg-white text-indigo-600 font-bold py-3 px-8 rounded-full shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300">
              Mulai Petualangan 🚀
            </button>
            <Link to="/minigames" onClick={() => sfx.play('click')} className="ui bg-indigo-700/50 hover:bg-indigo-700/70 text-white font-bold py-3 px-8 rounded-full backdrop-blur-md border border-white/20 transition-all duration-300">
              Main Mini Games 🎮
            </Link>
          </div>
        </div>

        {/* Decorative Elements */}
        <div className="absolute top-0 right-0 -mt-10 -mr-10 w-64 h-64 bg-white/10 rounded-full blur-3xl"></div>
        <div className="absolute bottom-0 left-0 -mb-10 -ml-10 w-40 h-40 bg-yellow-300/20 rounded-full blur-2xl"></div>
        <div className="absolute right-10 bottom-10 text-9xl opacity-10 rotate-12 select-none">🎓</div>
      </section>

      {/* Quick Stats / Features */}
      <section className="grid grid-cols-2 md:grid-cols-4 gap-4">
        <StatCard icon="🔥" label="Streak" value={`${streak} Hari`} color="bg-orange-100 text-orange-600" />
        <StatCard icon="⭐" label="Total XP" value="1,250" color="bg-yellow-100 text-yellow-600" />
        <StatCard icon="🏆" label="Peringkat" value="#5" color="bg-blue-100 text-blue-600" />
        <StatCard icon="📚" label="Materi" value="12 Selesai" color="bg-green-100 text-green-600" />
      </section>

      {/* Courses Grid */}
      <div id="courses">
        <CourseGrid query={new URLSearchParams(location.search).get('q') || ''} />
      </div>
    </div>
  )
}

function StatCard({ icon, label, value, color }) {
  return (
    <div className={`rounded-2xl p-4 ${color} border-2 border-transparent hover:border-current transition-all duration-300 cursor-default`}>
      <div className="text-2xl mb-1">{icon}</div>
      <div className="font-bold text-xl">{value}</div>
      <div className="text-xs font-medium opacity-80 uppercase tracking-wide">{label}</div>
    </div>
  )
}
