import React from 'react'
import { useParams } from 'react-router-dom'
import { api } from '../api/mock'
import CoursePlayer from '../components/CoursePlayer'

export default function Course(){
  const { id } = useParams()
  const [course,setCourse] = React.useState(null)
  React.useEffect(()=>{ (async()=>{
    const list = await api.getCourses(); setCourse(list.find(c=>c.id===id))
  })() },[id])
  if(!course) return <p className="ui">Memuat…</p>
  return (
    <div>
      <h1 className="heading text-onme-blue text-2xl mb-3">{course.title}</h1>
      <CoursePlayer course={course} />
    </div>
  )
}
