import React from 'react'
import { sfx } from '../utils/audio'
import { reward, toast } from './Toasts'

const sample = {
  q: '5 + 3 = ?'
 , options: ['6','7','8','9']
 , answer: '8'
}

export default function Quiz({ onCorrect }){
  const [picked,setPicked] = React.useState(null)
  const [result,setResult] = React.useState(null)

  const check = (opt)=>{
    setPicked(opt)
    const ok = opt===sample.answer
    setResult(ok?'benar':'salah')
    sfx.play(ok?'success':'error')
    toast(ok?'Jawaban benar!': 'Ups, coba lagi', ok?'success':'error')
    if(ok){ reward(); onCorrect && onCorrect() }
  }

  return (
    <div className="mb-3" aria-label="Kuis cepat">
      <p className="ui font-bold mb-2">Kuis: {sample.q}</p>
      <div className="grid grid-cols-2 gap-2">
        {sample.options.map(o=> (
          <button key={o} onClick={()=>check(o)} className={`ui rounded-xl px-3 py-2 border-2 focus:shadow-glow ${picked===o ? 'border-onme-blue' : 'border-onme-softBlue'} ${result && o===sample.answer ? 'bg-onme-lime' : 'bg-white'}`}>{o}</button>
        ))}
      </div>
    </div>
  )
}
