import React from 'react'
import { api } from '../api/mock'
import { sfx } from '../utils/audio'

export default function MiniGamesZone() {
  const [games, setGames] = React.useState([])
  const [open, setOpen] = React.useState(null)
  React.useEffect(() => { (async () => setGames(await api.getGames()))() }, [])
  return (
    <section className="mt-8" aria-label="Mini Games">
      <h2 className="heading text-onme-blue text-xl mb-3">Mini-Games Zone</h2>
      <div className="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-6 gap-3">
        {games.map(g => (
          <button key={g.id} onClick={() => { setOpen(g); sfx.play('click') }} className="bg-white rounded-2xl border-2 border-onme-softBlue aspect-square p-2 hover:-translate-y-1 transition focus:shadow-glow">
            <div className="w-full h-full rounded-xl flex items-center justify-center text-center ui font-bold text-onme-blue" aria-label={`Buka game ${g.title}`}>
              {g.title}
            </div>
          </button>
        ))}
      </div>
      {open && (
        <div role="dialog" aria-modal="true" className="fixed inset-0 bg-black/40 grid place-items-center p-4">
          <div className="bg-white max-w-md w-full rounded-2xl p-4 border-4 border-onme-blue">
            <h3 className="heading text-onme-blue text-xl mb-2">{open.title}</h3>
            <p className="ui mb-4">Demo stub permainan web. Guru dapat menautkan game web internal di sini.</p>
            <div className="flex justify-end gap-2">
              <a
                href="http://localhost/landingpage1/lomba/"
                target="_blank"
                rel="noopener noreferrer"
                onClick={() => { sfx.play('success'); setOpen(null) }}
                className="ui rounded-full bg-onme-lime px-4 py-2 font-bold"
              >
                Main!
              </a>
              <button className="ui rounded-full bg-white border-2 border-onme-softBlue px-4 py-2" onClick={() => { sfx.play('click'); setOpen(null) }}>Tutup</button>
            </div>
          </div>
        </div>
      )}
    </section>
  )
}
