import React from 'react'
import { getUser as getUserLS } from '../utils/storage'

export default function FriendsBar() {
  const [friends, setFriends] = React.useState([])
  const user = getUserLS()

  const fetchFriends = async () => {
    if (!user?.id) return
    try {
      const res = await fetch(`http://localhost/landingpage1/lomba/friends.php?user_id=${user.id}&type=friends`)
      const data = await res.json()
      if (Array.isArray(data)) setFriends(data)
    } catch (e) { console.error(e) }
  }

  React.useEffect(() => { fetchFriends() }, [user?.id])

  if (!user) return null

  return (
    <section aria-label="Teman" className="mt-3 mb-6">
      <div className="flex items-center justify-between mb-3">
        <h2 className="heading text-onme-blue text-xl">Teman Belajar</h2>
      </div>

      {friends.length === 0 ? (
        <div className="text-center py-6 bg-slate-50 rounded-xl border-2 border-dashed border-slate-200 text-slate-400 text-sm">
          Belum ada teman. Yuk ajak temanmu belajar bareng!
        </div>
      ) : (
        <div className="flex gap-3 overflow-x-auto pb-2 scrollbar-hide" role="list">
          {friends.map(f => (
            <div key={f.id} role="listitem" className="shrink-0 w-28 p-3 rounded-2xl bg-white border-2 border-onme-softBlue hover:border-indigo-400 transition-colors shadow-sm">
              <div className="h-14 w-14 rounded-full mx-auto mb-2 flex items-center justify-center text-white font-bold text-xl shadow-inner" style={{ background: f.color }}>
                {f.name.charAt(0).toUpperCase()}
              </div>
              <p className="ui text-center text-sm font-bold text-slate-700 truncate" title={f.name}>{f.name}</p>
              <p className="text-center text-[10px] text-slate-400 truncate">{f.role === 'admin' ? 'Guru' : 'Siswa'}</p>
            </div>
          ))}
        </div>
      )}
    </section>
  )
}
