import { getUser } from '../utils/storage'

const API = import.meta.env.VITE_API_BASE || ''

async function post(path, body){
  const resp = await fetch(`${API}/${path}`,{ method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(body) })
  if(!resp.ok) throw new Error('API error')
  return resp.json()
}
async function get(path, params){
  const url = new URL(`${API}/${path}`)
  Object.entries(params||{}).forEach(([k,v])=> url.searchParams.set(k,v))
  const resp = await fetch(url.toString())
  if(!resp.ok) throw new Error('API error')
  return resp.json()
}

export const colorTestApi = {
  save: (payload)=> post('color_test_save.php', payload),
  get: (user_id)=> get('color_test_get.php', { user_id }),
  event: (payload)=> post('color_test_event.php', payload),
  ishiharaList: ()=> get('ishihara_list.php'),
}
