import { getUsers, setUsers, setUser as setUserLS, setRole as setRoleLS, getUser as getUserLS } from '../utils/storage'

const genId = ()=> 'u_' + Math.random().toString(36).slice(2,10)
const hash = (s)=> {
  try { return btoa(unescape(encodeURIComponent(s))) } catch { return btoa(s) }
}

export function getCurrentUser(){ return getUserLS() }

export function register({ name, email, password, role }){
  const users = getUsers()
  const exists = users.find(u=> u.email.toLowerCase() === email.toLowerCase())
  if (exists) throw new Error('Email sudah terdaftar')
  const user = { id: genId(), name: name || (role==='admin'?'Guru SD':'Siswa SD'), email, pass: hash(password), role }
  users.push(user); setUsers(users)
  // auto login
  setRoleLS(role); setUserLS({ id: user.id, name: user.name, email: user.email, role })
  return { id: user.id, name: user.name, email: user.email, role }
}

export function loginWithEmail({ email, password }){
  const users = getUsers()
  const u = users.find(x=> x.email.toLowerCase() === email.toLowerCase())
  if (!u) throw new Error('User tidak ditemukan')
  if (u.pass !== hash(password)) throw new Error('Password salah')
  setRoleLS(u.role); setUserLS({ id: u.id, name: u.name, email: u.email, role: u.role })
  return { id: u.id, name: u.name, email: u.email, role: u.role }
}

export function loginWithGoogle({ email, name }){
  const users = getUsers()
  let u = users.find(x=> x.email.toLowerCase() === email.toLowerCase())
  if (!u) {
    u = { id: genId(), name: name || 'Siswa', email, pass: null, role: 'student' }
    users.push(u); setUsers(users)
  }
  setRoleLS('student'); setUserLS({ id: u.id, name: u.name, email: u.email, role: 'student' })
  return { id: u.id, name: u.name, email: u.email, role: 'student' }
}

export function logout(){ setRoleLS(null); setUserLS(null) }
