<?php
require __DIR__.'/config.php';
// List ishihara dataset files under public/ishihara/data and infer expected digit from filename prefix like `0_...png`
$base = realpath(__DIR__ . '/../klungklung-react/public/ishihara/data');
if (!$base || !is_dir($base)) { respond(['error'=>'DATASET_NOT_FOUND','dir'=>$base], 404); }
$files = glob($base.'/*.png');
$out = [];
foreach ($files as $f) {
  $name = basename($f);
  if (preg_match('/^(\d+)_/',$name,$m)) {
    $expected = $m[1];
  } else {
    $expected = null;
  }
  $cat = null; // protan|deutan|tritan if detectable
  if (preg_match('/type[_\s-]?(\d)/i', $name, $m2)) {
    $t = intval($m2[1]);
    if ($t === 1) $cat = 'protan';
    elseif ($t === 2) $cat = 'deutan';
    elseif ($t === 3) $cat = 'tritan';
  }
  $out[] = [
    'file' => $name,
    'url'  => '/ishihara/data/'.$name,
    'expected' => $expected,
    'cat' => $cat,
  ];
}
respond(['data'=>$out]);
