<?php
require __DIR__.'/config.php';
$data = json_input();
$user_id = intval($data['user_id'] ?? 0);
$ishihara = $data['ishihara_answers'] ?? [];
$d15 = $data['d15_order'] ?? [];
$class = $data['classification'] ?? null;
$severity = $data['severity'] ?? null;
$confidence = isset($data['confidence']) ? floatval($data['confidence']) : null;
$ishihara_summary = $data['ishihara_summary'] ?? null;
$axis = $data['axis'] ?? null;
$angle = isset($data['angle']) ? floatval($data['angle']) : null;
$total_error = isset($data['total_error']) ? intval($data['total_error']) : null;
$interpretation_text = $data['interpretation_text'] ?? null;

if ($user_id <= 0) { respond(['error'=>'INVALID_USER'], 400); }

try {
  // check existing
  $stmt = $pdo->prepare('SELECT id FROM color_tests WHERE user_id = ? LIMIT 1');
  $stmt->execute([$user_id]);
  $row = $stmt->fetch();

  if ($row) {
    $upd = $pdo->prepare('UPDATE color_tests SET ishihara_answers = :ih, d15_order = :d15, axis=:axis, angle=:angle, total_error=:te, classification=:c, severity=:s, confidence=:conf, ishihara_summary=:sum, interpretation_text=:it WHERE user_id = :uid');
    $upd->execute([
      ':ih' => json_encode($ishihara, JSON_UNESCAPED_UNICODE),
      ':d15'=> json_encode($d15, JSON_UNESCAPED_UNICODE),
      ':axis'=>$axis,
      ':angle'=>$angle,
      ':te'=>$total_error,
      ':c'=>$class,
      ':s'=>$severity,
      ':conf'=>$confidence,
      ':sum'=>$ishihara_summary,
      ':it'=>$interpretation_text,
      ':uid'=>$user_id,
    ]);
    $id = $row['id'];
  } else {
    $ins = $pdo->prepare('INSERT INTO color_tests (user_id, ishihara_answers, d15_order, axis, angle, total_error, classification, severity, confidence, ishihara_summary, interpretation_text) VALUES (:uid, :ih, :d15, :axis, :angle, :te, :c, :s, :conf, :sum, :it)');
    $ins->execute([
      ':uid'=>$user_id,
      ':ih'=> json_encode($ishihara, JSON_UNESCAPED_UNICODE),
      ':d15'=> json_encode($d15, JSON_UNESCAPED_UNICODE),
      ':axis'=>$axis,
      ':angle'=>$angle,
      ':te'=>$total_error,
      ':c'=>$class,
      ':s'=>$severity,
      ':conf'=>$confidence,
      ':sum'=>$ishihara_summary,
      ':it'=>$interpretation_text,
    ]);
    $id = $pdo->lastInsertId();
  }

  respond(['ok'=>true, 'id'=>$id]);
} catch (Throwable $e) {
  respond(['error'=>'SAVE_FAILED','message'=>$e->getMessage()], 500);
}
