<?php
require __DIR__.'/config.php';
$user_id = intval($_GET['user_id'] ?? 0);
if ($user_id <= 0) { respond(['error'=>'INVALID_USER'], 400); }
try {
  $stmt = $pdo->prepare('SELECT * FROM color_tests WHERE user_id = ? LIMIT 1');
  $stmt->execute([$user_id]);
  $row = $stmt->fetch();
  if (!$row) respond(['data'=>null]);
  // Cast json
  foreach (['ishihara_answers','d15_order'] as $k) {
    if (isset($row[$k]) && is_string($row[$k])) {
      $row[$k] = json_decode($row[$k], true);
    }
  }
  respond(['data'=>$row]);
} catch (Throwable $e) {
  respond(['error'=>'GET_FAILED','message'=>$e->getMessage()], 500);
}
