<?php
require __DIR__.'/config.php';
$data = json_input();
$user_id = intval($data['user_id'] ?? 0);
$event_type = $data['event_type'] ?? '';
$payload = $data['payload'] ?? null;
if ($user_id <= 0 || !$event_type) { respond(['error'=>'INVALID_INPUT'], 400); }
try {
  $ins = $pdo->prepare('INSERT INTO color_test_events (user_id, event_type, payload) VALUES (:uid, :ev, :pl)');
  $ins->execute([
    ':uid'=>$user_id,
    ':ev'=>$event_type,
    ':pl'=> json_encode($payload, JSON_UNESCAPED_UNICODE),
  ]);
  respond(['ok'=>true, 'id'=>$pdo->lastInsertId()]);
} catch (Throwable $e) {
  respond(['error'=>'EVENT_FAILED','message'=>$e->getMessage()], 500);
}
